/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.io.File;
import java.io.FileReader;
import javax.swing.JOptionPane;
import net.espley.microprocessor.IMemory;
import net.espley.processor.PropertyStatus;
import net.espley.processor.Utility;
import net.espley.processor.devices.ScreenFrame;

public class DataFileReader {
    File file;
    ScreenFrame frame;
    boolean readOnly;

    public DataFileReader(File file, boolean readOnly) {
        this.file = file;
        this.readOnly = readOnly;
    }

    void setMemory() {
    }

    public void setFrame(ScreenFrame frame) {
        this.frame = frame;
    }

    public void readFile(IMemory memory) {
        char[] cbuf = new char[35];
        Utility utility = new Utility();
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Reading file");
        }
        try {
            int len;
            FileReader source = new FileReader(this.file);
            while ((len = source.read(cbuf, 0, cbuf.length)) != -1 && cbuf[0] != '.') {
                String line = new String(cbuf);
                int address = utility.getHexValue(line.substring(0, 4));
                int base = 5;
                for (int i = 0; i < 8; ++i) {
                    memory.writeByteDirect(address + i, (int)((short)utility.getHexValue(line.substring(base, base + 2))));
                    memory.setReadStatus(address + i, this.readOnly);
                    base += 3;
                }
            }
            source.close();
        }
        catch (Exception e) {
            System.out.println("File not found ".concat(String.valueOf(String.valueOf(e))));
            JOptionPane.showMessageDialog(this.frame, "Unable to read the file:\n".concat(String.valueOf(String.valueOf(this.file.getAbsolutePath()))), "Read File", 0);
        }
    }
}

