/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JOptionPane;
import net.espley.processor.Utility;
import net.espley.processor.devices.ScreenFrame;

public class Diskreader {
    Utility util = new Utility();
    private byte[][][] disk0 = new byte[80][16][256];
    private byte[][][] disk1 = new byte[80][16][256];
    private ScreenFrame frame;
    static Class class$net$espley$processor$Resource;

    public Diskreader(ScreenFrame frame) {
        for (int track = 0; track < this.disk0.length; ++track) {
            for (int sector = 0; sector < this.disk0[0].length; ++sector) {
                for (int position = 0; position < this.disk0[0][0].length; ++position) {
                    this.disk0[track][sector][position] = -1;
                    this.disk1[track][sector][position] = -1;
                }
            }
        }
        this.frame = frame;
    }

    public void loadDisk(File file) {
        byte[] headerBlock = new byte[8];
        byte[] sectorBlock = new byte[256];
        try {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            while (fis.read(headerBlock) != -1) {
                byte cylinder = headerBlock[0];
                byte side = headerBlock[1];
                byte sector = headerBlock[4];
                byte lengthCode = headerBlock[5];
                int count = headerBlock[6] + headerBlock[7] << 8;
                fis.read(sectorBlock, 0, count);
                if (!(sector < 32 & cylinder < 3)) continue;
                System.arraycopy(sectorBlock, 0, this.disk0[cylinder][sector - 1], 0, count);
                System.out.println("---------------------------------");
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Track;").append(cylinder).append(" Sector:").append(sector))));
                this.dumpSector(this.disk0[cylinder][sector - 1]);
            }
            System.out.println("File     exec load trck sctr len");
            for (int i = 3; i <= 16; ++i) {
                this.printDirectory(this.disk0[0][i - 1]);
            }
            fis.close();
        }
        catch (Exception e) {
            if (this.frame == null) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.frame, "Unable to load the disk file:\n".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))), "Load Disk", 0);
        }
    }

    public void diskDumpReader(File file) {
        try {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            for (int track = 0; track < this.disk0.length; ++track) {
                int position;
                int sector;
                for (sector = 0; sector < this.disk0[0].length; ++sector) {
                    for (position = 0; position < this.disk0[0][0].length; ++position) {
                        this.disk0[track][sector][position] = (byte)fis.read();
                    }
                }
                for (sector = 0; sector < this.disk1[0].length; ++sector) {
                    for (position = 0; position < this.disk1[0][0].length; ++position) {
                        this.disk1[track][sector][position] = (byte)fis.read();
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.frame == null) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.frame, "Unable to load the disk file:\n".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))), "Load Disk", 0);
        }
    }

    public byte[][][] getDiskImage0() {
        return this.disk0;
    }

    public byte[][][] getDiskImage1() {
        return this.disk1;
    }

    public int getByte(byte[] sector, int location) {
        int p1 = sector[location];
        if (p1 < 0) {
            p1 += 256;
        }
        return p1;
    }

    public int getWord(byte[] sector, int location) {
        int p2;
        int p1 = sector[location];
        if (p1 < 0) {
            p1 += 256;
        }
        if ((p2 = sector[location + 1]) < 0) {
            p2 += 256;
        }
        return (p2 << 8) + p1;
    }

    public void printDirectory(byte[] sector) {
        for (int i = 0; i < sector.length; i += 16) {
            if (sector[i] < 0) continue;
            String fileName = new String(sector, i, 8);
            int executionAddress = this.getWord(sector, i + 8);
            int loadAddress = this.getWord(sector, i + 10);
            int startTrack = this.getByte(sector, i + 12);
            int startSector = this.getByte(sector, i + 13);
            int length = this.getWord(sector, i + 14);
            System.out.print(String.valueOf(String.valueOf(fileName)).concat(" "));
            System.out.print(String.valueOf(String.valueOf(this.util.getWord(executionAddress))).concat(" "));
            System.out.print(String.valueOf(String.valueOf(this.util.getWord(loadAddress))).concat(" "));
            System.out.print(String.valueOf(String.valueOf(this.util.getWord(startTrack))).concat(" "));
            System.out.print(String.valueOf(String.valueOf(this.util.getWord(startSector))).concat(" "));
            System.out.print(String.valueOf(String.valueOf(this.util.getWord(length))).concat(" "));
            System.out.println();
        }
    }

    public void dumpSector(byte[] sector) {
        for (int i = 0; i < sector.length; i += 16) {
            int value;
            int j;
            for (j = 0; j < 16; ++j) {
                value = sector[i + j];
                if (value < 0) {
                    value += 256;
                }
                System.out.print(String.valueOf(String.valueOf(this.util.getByte(value))).concat(" "));
            }
            for (j = 0; j < 16; ++j) {
                value = sector[i + j];
                if (value < 0) {
                    value += 256;
                }
                if (value > 31 && value < 128) {
                    System.out.print((char)value);
                    continue;
                }
                System.out.print(".");
            }
            System.out.println();
        }
    }

    public void dumpFile(String fileName) {
        byte[] buffer = new byte[16];
        try {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fileName));
            while (-1 != fis.read(buffer)) {
                int value;
                int j;
                for (j = 0; j < 16; ++j) {
                    value = buffer[j];
                    if (value < 0) {
                        value += 256;
                    }
                    System.out.print(String.valueOf(String.valueOf(this.util.getByte(value))).concat(" "));
                }
                for (j = 0; j < 16; ++j) {
                    value = buffer[j];
                    if (value < 0) {
                        value += 256;
                    }
                    if (value > 31 && value < 128) {
                        System.out.print((char)value);
                        continue;
                    }
                    System.out.print(".");
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dumpANADiskToFile(byte[][][] diskImage, String fileName) {
        try {
            System.out.println("Saving disk to ".concat(String.valueOf(String.valueOf(fileName))));
            FileOutputStream fos = new FileOutputStream(fileName);
            for (int track = 0; track < diskImage.length; ++track) {
                for (int sector = 0; sector < diskImage[0].length; ++sector) {
                    fos.write(track);
                    fos.write(0);
                    fos.write(track);
                    fos.write(0);
                    fos.write(sector + 1);
                    fos.write(1);
                    fos.write(diskImage[0][0].length & 0xFF);
                    fos.write((diskImage[0][0].length & 0xFF00) >> 8);
                    fos.write(diskImage[track][sector], 0, diskImage[0][0].length);
                }
            }
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dumpDiskToFile(byte[][][] diskImage0, byte[][][] diskImage1, String fileName) {
        try {
            System.out.println("Saving disk to ".concat(String.valueOf(String.valueOf(fileName))));
            FileOutputStream fos = new FileOutputStream(fileName);
            for (int track = 0; track < diskImage0.length; ++track) {
                int sector;
                for (sector = 0; sector < diskImage0[0].length; ++sector) {
                    fos.write(diskImage0[track][sector], 0, diskImage0[0][0].length);
                }
                for (sector = 0; sector < diskImage1[0].length; ++sector) {
                    fos.write(diskImage1[track][sector], 0, diskImage1[0][0].length);
                }
            }
            fos.close();
        }
        catch (Exception e) {
            if (this.frame == null) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.frame, "Unable to save the disk file:\n".concat(String.valueOf(String.valueOf(fileName))), "Save Disk", 0);
        }
    }

    public static void main(String[] args) {
        Diskreader diskReader1 = new Diskreader(null);
        diskReader1.dumpFile(String.valueOf(String.valueOf((class$net$espley$processor$Resource == null ? (class$net$espley$processor$Resource = Diskreader.class$("net.espley.processor.Resource")) : class$net$espley$processor$Resource).getResource("").getFile())).concat("UTD1066.DSK"));
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

