/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import javax.swing.Box;
import javax.swing.SwingUtilities;
import net.espley.microprocessor.IMemory;
import net.espley.microprocessor.Z80;
import net.espley.processor.Computer;
import net.espley.processor.Keyboard;
import net.espley.processor.PaintCell;
import net.espley.processor.PropertyStatus;
import net.espley.processor.VideoROM;
import net.espley.processor.devices.GUIListener;
import net.espley.processor.devices.KeyboardHandler;
import net.espley.processor.devices.ScreenComponent;
import net.espley.processor.devices.ScreenFrame;
import net.espley.processor.devices.WindowHandler;

public class Display
implements IMemory {
    protected final int maxAddress = 65535;
    public final boolean debug = false;
    public final int rowBits = 8;
    public final int columnBits = 16;
    public final int rows = 16;
    public final int columns = 48;
    public final int characters = 256;
    public final int scale = 2;
    public final int videoBase = 2048;
    public final int videoSize = 1024;
    public final int videoTop = 3072;
    public final int leftMargin = 10;
    public final int rightMargin = 7;
    public final int lineLength = 64;
    public final int rightBorder = 57;
    public int[][] screen;
    public ScreenComponent[][] cells;
    public Image[] icons;
    private PaintCell paintCell;
    public ScreenFrame screenFrame;
    public Computer computer;
    public Box[] screenRow;
    public Box wholeScreen;
    private boolean multiprocessor;
    public VideoROM rom;
    public Keyboard keyboard;

    public Display(Keyboard keyboard, VideoROM rom, GUIListener guiListener, Computer computer, Z80 z80) {
        block3: {
            int row;
            this.maxAddress = 65535;
            this.debug = false;
            this.rowBits = 8;
            this.columnBits = 16;
            this.rows = 16;
            this.columns = 48;
            this.characters = 256;
            this.scale = 2;
            this.videoBase = 2048;
            this.videoSize = 1024;
            this.videoTop = 3072;
            this.leftMargin = 10;
            this.rightMargin = 7;
            this.lineLength = 64;
            this.rightBorder = 57;
            this.screen = new int[16][48];
            this.cells = new ScreenComponent[16][48];
            this.icons = new Image[256];
            this.paintCell = new PaintCell();
            this.screenRow = new Box[16];
            this.keyboard = keyboard;
            this.rom = rom;
            this.computer = computer;
            this.screenFrame = new ScreenFrame("Nascom 2 Display", guiListener);
            this.reset();
            ((Component)this.screenFrame).setBounds(0, 0, 800, 640);
            this.wholeScreen = Box.createVerticalBox();
            for (row = 0; row < 16; ++row) {
                this.screenRow[row] = Box.createHorizontalBox();
                for (int column = 0; column < 48; ++column) {
                    this.screenRow[row].add(this.cells[row][column]);
                }
            }
            for (row = 0; row < 16; ++row) {
                this.wholeScreen.add(this.screenRow[(row + 16 - 1) % 16]);
            }
            this.screenFrame.getContentPane().setLayout(new FlowLayout());
            this.screenFrame.getContentPane().add(this.wholeScreen);
            this.screenFrame.addWindowListener(new WindowHandler());
            this.screenFrame.addKeyListener(new KeyboardHandler(keyboard));
            this.multiprocessor = PropertyStatus.getInstance().getMultiprocessor();
            ((Component)this.screenFrame).setVisible(true);
            if (!PropertyStatus.getInstance().getLogging()) break block3;
            System.out.println("Standard video test complete");
        }
    }

    public ScreenFrame getScreenFrame() {
        return this.screenFrame;
    }

    private final Image getImageIcon(int cell) {
        int romAddress = cell * 16;
        int offset = 0;
        int[] pic = new int[128];
        int pixelOff = 0;
        int pixelOn = -1;
        for (int i = 0; i < 16; ++i) {
            int bitMask = 128;
            int charValue = this.rom.readByte(romAddress + i);
            for (int bit = 0; bit < 8; ++bit) {
                pic[offset++] = (bitMask & charValue) == 0 ? pixelOff : pixelOn;
                bitMask >>>= 1;
            }
        }
        Image baseImage = this.screenFrame.createImage(new MemoryImageSource(8, 16, pic, 0, 8));
        baseImage = baseImage.getScaledInstance(16, 32, 1);
        return baseImage;
    }

    public final void printByte(int row, int column, int character) {
        ScreenComponent sc = this.cells[row][column];
        try {
            if (this.multiprocessor) {
                this.paintCell = new PaintCell();
                this.paintCell.setParameters(sc, this.icons[character]);
                SwingUtilities.invokeLater(this.paintCell);
            } else {
                this.paintCell.setParameters(sc, this.icons[character]);
                SwingUtilities.invokeAndWait(this.paintCell);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void printString(int row, int column, String str) {
        byte[] strBytes = str.getBytes();
        for (int offset = 0; offset < str.length(); ++offset) {
            this.printByte(row, column + offset, strBytes[offset]);
        }
    }

    public void reset() {
        int column;
        int row;
        for (row = 0; row < 16; ++row) {
            for (column = 0; column < 48; ++column) {
                this.screen[row][column] = 65;
            }
        }
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Screen video ram cleared");
        }
        for (int character = 0; character < 256; ++character) {
            this.icons[character] = this.getImageIcon(character);
        }
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Image cells loaded");
        }
        for (row = 0; row < 16; ++row) {
            for (column = 0; column < 48; ++column) {
                ScreenComponent sc = new ScreenComponent(this.icons[this.screen[row][column]]);
                sc.setPreferredSize(new Dimension(16, 32));
                this.cells[row][column] = sc;
            }
        }
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Screen video painted");
        }
    }

    public int memoryRead(int address) {
        return 0;
    }

    public final void setReadStatus(int address, boolean readOnly) {
    }

    public final void writeWordDirect(int address, int data) {
        this.writeByteDirect(address, data & 0xFF);
        address = address + 1 & 0xFFFF;
        this.writeByteDirect(address, data >>>= 8);
    }

    public void writeByteDirect(int address, int data) {
        this.writeByte(address, data);
    }

    public final void writeWord(int address, int data) {
        this.writeByte(address, data & 0xFF);
        address = address + 1 & 0xFFFF;
        this.writeByte(address, data >>>= 8);
    }

    public final int readWordDirect(int address) {
        return this.readByteDirect(address) + this.readByteDirect(address + 1 & 0xFFFF) * 256;
    }

    public final int readWord(int address) {
        return this.readByte(address) + this.readByte(address + 1 & 0xFFFF) * 256;
    }

    public final int readByteDirect(int address) {
        return 0;
    }

    public final int readByte(int address) {
        return 0;
    }

    public void writeByte(int address, int data) {
        block2: {
            if (address >= 3072 || address < 2048) break block2;
            if (this.readByteDirect(address) == data) {
                return;
            }
            int column = (address -= 2048) & 0x3F;
            if (column >= 10 && column <= 57) {
                int row = address >>> 6;
                this.printByte(row, column -= 10, data);
            }
        }
    }
}

