/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.io.File;
import net.espley.microprocessor.IBaseDevice;
import net.espley.processor.Diskreader;
import net.espley.processor.IOPorts;
import net.espley.processor.Utility;
import net.espley.processor.devices.ScreenFrame;

public class FDC
implements IBaseDevice {
    private static final int statusPort = 224;
    private static final int commandPort = 224;
    private static final int trackPort = 225;
    private static final int sectorPort = 226;
    private static final int dataPort = 227;
    private static final int drivePort = 228;
    private static final int intrqPort = 229;
    private int statusRegister;
    private int commandRegister;
    private int trackRegister;
    private int sectorRegister;
    private int dataRegister;
    private int driveRegister;
    private int intrqRegister;
    private static final int NOTREADY = 128;
    private static final int WRITEPROTECT = 64;
    private static final int HEAD = 32;
    private static final int SEEKERROR = 16;
    private static final int CRCERROR = 8;
    private static final int TRACK0 = 4;
    private static final int INDEX = 2;
    private static final int BUSY = 1;
    private static final int headBit = 128;
    private static final int maxTrack = 76;
    private int track;
    private int sector;
    private int side;
    private boolean stepIn;
    private boolean runMotor;
    private boolean highDensity;
    private boolean multiple;
    private IOPorts io;
    private Utility util;
    private Diskreader diskReader;
    private int[] outputBuffer;
    private int bufferPosition;
    private byte[][][] selectedDisk;
    private byte[][][] disk0 = new byte[80][16][256];
    private byte[][][] disk1 = new byte[80][16][256];
    private byte[][][] disk2 = new byte[80][16][256];
    private byte[][][] disk3 = new byte[80][16][256];
    private byte[][][] disk4 = new byte[80][16][256];
    private byte[][][] disk5 = new byte[80][16][256];
    private byte[][][] disk6 = new byte[80][16][256];
    private byte[][][] disk7 = new byte[80][16][256];
    private ScreenFrame frame;

    public FDC(IOPorts io) {
        this.io = io;
        this.util = new Utility();
        this.statusRegister = 0;
        this.trackRegister = 0;
        this.sectorRegister = 1;
        this.dataRegister = 0;
        this.driveRegister = 0;
        this.intrqRegister = 0;
        this.track = 0;
        this.sector = 1;
        this.side = 0;
        this.stepIn = true;
        this.runMotor = false;
        this.highDensity = true;
        this.multiple = false;
        this.bufferPosition = -1;
        this.resetMemoryDisk(this.disk0);
        this.resetMemoryDisk(this.disk1);
        this.resetMemoryDisk(this.disk2);
        this.resetMemoryDisk(this.disk3);
        this.resetMemoryDisk(this.disk4);
        this.resetMemoryDisk(this.disk5);
        this.resetMemoryDisk(this.disk6);
        this.resetMemoryDisk(this.disk7);
        this.selectedDisk = this.disk0;
        this.diskReader = new Diskreader(this.frame);
        this.diskReader.diskDumpReader(new File("blank.dsk"));
        this.disk0 = this.diskReader.getDiskImage0();
        this.disk1 = this.diskReader.getDiskImage1();
        this.diskReader = new Diskreader(this.frame);
        this.diskReader.diskDumpReader(new File("blank.dsk"));
        this.disk2 = this.diskReader.getDiskImage0();
        this.disk3 = this.diskReader.getDiskImage1();
        this.diskReader = new Diskreader(this.frame);
        this.diskReader.diskDumpReader(new File("blank.dsk"));
        this.disk4 = this.diskReader.getDiskImage0();
        this.disk5 = this.diskReader.getDiskImage1();
        this.diskReader = new Diskreader(this.frame);
        this.diskReader.diskDumpReader(new File("blank.dsk"));
        this.disk6 = this.diskReader.getDiskImage0();
        this.disk7 = this.diskReader.getDiskImage1();
    }

    public void setFrame(ScreenFrame frame) {
        this.frame = frame;
    }

    public boolean supportsMemoryReads() {
        return false;
    }

    public boolean supportsMemoryWrites() {
        return false;
    }

    public boolean supportsIOReads() {
        return true;
    }

    public boolean supportsIOWrites() {
        return true;
    }

    public final int memoryRead(int address) {
        return 0;
    }

    public void memoryWrite(int address, int data) {
    }

    private void resetMemoryDisk(byte[][][] diskImage) {
        for (int track = 0; track < diskImage.length; ++track) {
            for (int sector = 0; sector < diskImage[0].length; ++sector) {
                for (int position = 0; position < diskImage[0][0].length; ++position) {
                    diskImage[track][sector][position] = -1;
                }
            }
        }
    }

    public int IORead(int address) {
        switch (address) {
            case 224: {
                this.readStatus();
                break;
            }
            case 225: {
                this.readTrack();
                break;
            }
            case 226: {
                this.readSector();
                break;
            }
            case 227: {
                this.readData();
                break;
            }
            case 228: {
                this.readDrive();
                break;
            }
            case 229: {
                this.readIntrq();
            }
        }
        return 0;
    }

    private void readStatus() {
        this.io.writeByteDirect(224, this.statusRegister);
    }

    private void readTrack() {
        this.io.writeByteDirect(225, this.trackRegister);
    }

    private void readSector() {
        this.io.writeByteDirect(226, this.sectorRegister);
    }

    private void readDrive() {
        this.io.writeByteDirect(228, this.driveRegister);
    }

    private void readData() {
        if (-1 != this.bufferPosition) {
            this.dataRegister = this.outputBuffer[this.bufferPosition++];
        }
        if (this.bufferPosition == this.outputBuffer.length) {
            this.bufferPosition = -1;
            this.statusRegister = 0;
            this.intrqRegister = 1;
        }
        this.io.writeByteDirect(227, this.dataRegister);
    }

    private void readIntrq() {
        this.io.writeByteDirect(229, this.intrqRegister);
    }

    public void IOWrite(int address, int data) {
        switch (address) {
            case 224: {
                this.writeCommand(data);
                break;
            }
            case 225: {
                this.writeTrack(data);
                break;
            }
            case 226: {
                this.writeSector(data);
                break;
            }
            case 227: {
                this.writeData(data);
                break;
            }
            case 228: {
                this.writeDrive(data);
            }
        }
    }

    private void writeCommand(int data) {
        this.commandRegister = data;
        switch (this.commandRegister & 0xE0) {
            case 0: {
                this.restoreSeek();
                break;
            }
            case 32: {
                this.step();
                break;
            }
            case 64: {
                this.stepIn();
                break;
            }
            case 96: {
                this.stepOut();
                break;
            }
            case 128: {
                this.readSectorCMD();
                break;
            }
            case 160: {
                this.writeSectorCMD();
                break;
            }
            case 192: {
                this.readAddressInt();
                break;
            }
            case 224: {
                this.readWriteTrack();
            }
        }
    }

    private void restoreSeek() {
        if ((this.commandRegister & 0x10) == 0) {
            this.track = 0;
            this.statusRegister = (this.commandRegister & 0x80) == 0 ? 4 : 36;
        } else {
            this.track = this.dataRegister;
            this.trackRegister = this.dataRegister;
            this.statusRegister = (this.commandRegister & 0x80) == 0 ? 4 : 36;
        }
    }

    private void stepIn() {
        if (this.track <= 76) {
            ++this.track;
        }
        this.trackRegister = this.track;
        this.statusRegister = 32;
    }

    private void stepOut() {
        if (this.track > 0) {
            --this.track;
        }
        this.trackRegister = this.track;
        this.statusRegister = this.track == 0 ? 4 : 0;
        this.statusRegister |= 0x20;
    }

    private void step() {
        if (this.stepIn && this.track <= 76) {
            ++this.track;
        } else if (this.track > 0) {
            --this.track;
        }
        this.trackRegister = this.track;
        this.statusRegister = this.track == 0 ? 4 : 0;
        this.statusRegister |= 0x20;
    }

    private void readSectorCMD() {
        int length = this.selectedDisk[this.track][this.sector - 1].length;
        this.outputBuffer = new int[length];
        for (int position = 0; position < length; ++position) {
            int value = this.selectedDisk[this.track][this.sector - 1][position];
            if (value < 0) {
                value += 256;
            }
            this.outputBuffer[position] = value;
        }
        this.bufferPosition = 0;
        this.statusRegister |= 1;
        this.intrqRegister = 128;
    }

    private void writeSectorCMD() {
        this.bufferPosition = 0;
        this.statusRegister |= 1;
        this.intrqRegister = 128;
    }

    private void readAddressInt() {
        block0: {
            this.outputBuffer = new int[6];
            if ((this.commandRegister & 0x10) != 0) break block0;
            this.bufferPosition = 0;
            this.statusRegister |= 1;
            this.intrqRegister = 128;
            this.outputBuffer[0] = this.track;
            this.outputBuffer[1] = this.side;
            this.outputBuffer[2] = this.sector;
            this.outputBuffer[3] = 255;
            this.outputBuffer[4] = 0;
            this.outputBuffer[5] = 0;
        }
    }

    private void readWriteTrack() {
        if ((this.commandRegister & 0x10) != 0) {
            // empty if block
        }
    }

    private void writeTrack(int data) {
        this.trackRegister = data;
        this.statusRegister = this.track == 0 ? 4 : 0;
        this.statusRegister |= 0x20;
    }

    private void writeSector(int data) {
        this.sectorRegister = data;
        this.sector = data;
    }

    private void writeData(int data) {
        this.dataRegister = data;
        if (-1 != this.bufferPosition) {
            this.selectedDisk[this.track][this.sector - 1][this.bufferPosition++] = (byte)data;
            if (this.bufferPosition == this.selectedDisk[0][0].length) {
                this.bufferPosition = -1;
                this.statusRegister = 0;
                this.intrqRegister = 1;
            }
        }
    }

    private void writeDrive(int data) {
        this.driveRegister = data;
        switch (data & 0x1F) {
            case 1: {
                this.selectedDisk = this.disk0;
                break;
            }
            case 17: {
                this.selectedDisk = this.disk1;
                break;
            }
            case 2: {
                this.selectedDisk = this.disk2;
                break;
            }
            case 18: {
                this.selectedDisk = this.disk3;
                break;
            }
            case 4: {
                this.selectedDisk = this.disk4;
                break;
            }
            case 20: {
                this.selectedDisk = this.disk5;
                break;
            }
            case 8: {
                this.selectedDisk = this.disk6;
                break;
            }
            case 24: {
                this.selectedDisk = this.disk7;
                break;
            }
            default: {
                System.out.println("Illegal drive selection");
            }
        }
        this.side = (data & 0x10) == 0 ? 0 : 1;
        this.runMotor = (data & 0x20) != 0;
        this.highDensity = (data & 0x40) != 0;
    }

    public void saveDisk(int drive, String fileName) {
        switch (drive) {
            case 0: {
                this.diskReader.dumpDiskToFile(this.disk0, this.disk1, fileName);
                break;
            }
            case 1: {
                this.diskReader.dumpDiskToFile(this.disk2, this.disk3, fileName);
                break;
            }
            case 2: {
                this.diskReader.dumpDiskToFile(this.disk3, this.disk5, fileName);
                break;
            }
            case 3: {
                this.diskReader.dumpDiskToFile(this.disk6, this.disk7, fileName);
            }
        }
    }

    public void loadDisk(int drive, File file) {
        this.diskReader = new Diskreader(this.frame);
        this.diskReader.diskDumpReader(file);
        switch (drive) {
            case 0: {
                this.disk0 = this.diskReader.getDiskImage0();
                this.disk1 = this.diskReader.getDiskImage1();
                break;
            }
            case 1: {
                this.disk2 = this.diskReader.getDiskImage0();
                this.disk3 = this.diskReader.getDiskImage1();
                break;
            }
            case 2: {
                this.disk4 = this.diskReader.getDiskImage0();
                this.disk5 = this.diskReader.getDiskImage1();
                break;
            }
            case 3: {
                this.disk6 = this.diskReader.getDiskImage0();
                this.disk7 = this.diskReader.getDiskImage1();
            }
        }
    }

    static {
        statusPort = 224;
        commandPort = 224;
        trackPort = 225;
        sectorPort = 226;
        dataPort = 227;
        drivePort = 228;
        intrqPort = 229;
        NOTREADY = 128;
        WRITEPROTECT = 64;
        HEAD = 32;
        SEEKERROR = 16;
        CRCERROR = 8;
        TRACK0 = 4;
        INDEX = 2;
        BUSY = 1;
        headBit = 128;
        maxTrack = 76;
    }
}

