/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor.devices;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class AVCDrawing
extends JComponent {
    private Color[][] colourImageSmall;
    private Color[][] colourImageLarge;
    private Color[][] colourImage;
    private boolean highResImage = false;
    private int limitX = 392;
    private int limitY = 256;
    private int startX;
    private int startY;
    private int sizeX;
    private int sizeY;
    private int endX;
    private int endY;

    public AVCDrawing() {
        this.setBackground(Color.red);
    }

    public void setImageSmall(Color[][] colourImage) {
        this.colourImageSmall = colourImage;
    }

    public void setImageLarge(Color[][] colourImage) {
        this.colourImageLarge = colourImage;
    }

    public void setHighResMode() {
        this.highResImage = true;
        this.limitX = 784;
        this.limitY = 256;
    }

    public void setLowResMode() {
        this.highResImage = false;
        this.limitX = 392;
        this.limitY = 256;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.colourImageSmall == null) {
            System.out.println("Paint rejected - null");
            return;
        }
        Rectangle r = g.getClipBounds();
        this.startX = (int)r.getX();
        this.startY = (int)r.getY();
        this.sizeX = (int)r.getWidth();
        this.sizeY = (int)r.getHeight();
        this.endX = this.startX + this.sizeX;
        this.endY = this.startY + this.sizeY;
        if (this.endX > this.limitX) {
            this.endX = this.limitX;
        }
        if (this.endY > this.limitY) {
            this.endY = this.limitY;
        }
        this.colourImage = this.highResImage ? this.colourImageLarge : this.colourImageSmall;
        for (int row = this.startY; row < this.endY; ++row) {
            for (int column = this.startX; column < this.endX; ++column) {
                g.setColor(this.colourImage[row][column]);
                g.drawLine(column, row, column, row);
            }
        }
    }
}

