/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor.devices;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.espley.processor.Keyboard;

public class KeyboardHandler
implements KeyListener {
    private Keyboard keyboard;
    private boolean shiftKey = false;
    private boolean controlKey = false;
    private boolean graphicKey = false;
    private static final int ASCII_POUND = 35;

    public KeyboardHandler(Keyboard keyboard) {
        this.keyboard = keyboard;
    }

    public void keyTyped(KeyEvent e) {
        int keyValue = e.getKeyCode();
    }

    public void keyPressed(KeyEvent e) {
        int keyValue = e.getKeyChar();
        if (65535 == keyValue) {
            switch (e.getKeyCode()) {
                case 65406: {
                    keyValue = -1;
                    this.graphicKey = true;
                    break;
                }
                case 16: {
                    keyValue = -2;
                    this.shiftKey = true;
                    break;
                }
                case 17: {
                    keyValue = -3;
                    this.controlKey = true;
                    break;
                }
                case 9: {
                    keyValue = 0;
                    break;
                }
                case 38: {
                    keyValue = 19;
                    break;
                }
                case 40: {
                    keyValue = 20;
                    break;
                }
                case 39: {
                    keyValue = 18;
                    break;
                }
                case 37: {
                    keyValue = 17;
                }
            }
        } else {
            switch (e.getKeyChar()) {
                case '\u00a3': {
                    keyValue = 35;
                    break;
                }
                case '\n': {
                    if (this.controlKey) break;
                    keyValue = 13;
                }
            }
        }
        if (keyValue > 127) {
            keyValue = 0;
        }
        this.keyboard.setKeyStroke(keyValue);
    }

    public void keyReleased(KeyEvent e) {
        this.keyboard.resetBuffer();
        int keyValue = e.getKeyCode();
        switch (keyValue) {
            case 65406: {
                this.graphicKey = false;
                break;
            }
            case 16: {
                this.shiftKey = false;
                break;
            }
            case 17: {
                this.controlKey = false;
            }
        }
    }

    static {
        ASCII_POUND = 35;
    }
}

